<?php
declare(strict_types=1);

require_once __DIR__ . '/../../../src/middleware.php';
require_once __DIR__ . '/../../../src/helpers.php';
require_once __DIR__ . '/../../../src/db.php';
require_once __DIR__ . '/../../../src/csrf.php';
require_once __DIR__ . '/../../../src/Admin/ModuleService.php';

use App\Admin\ModuleService;

require_auth();
require_module('admin_panel');
require_permission('admin.modules.manage');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    redirect('/public/admin/modules');
}

csrf_verify();

$id = (int)($_POST['id'] ?? 0);
if ($id <= 0) {
    flash('error', 'ID inválido.');
    redirect('/public/admin/modules');
}

$pdo = db();
$svc = new ModuleService($pdo);

$mod = $svc->find($id);
if (!$mod) {
    flash('error', 'Módulo no encontrado.');
    redirect('/public/admin/modules');
}

$svc->delete($id);
flash('success', 'Módulo eliminado.');
redirect('/public/admin/modules');
