<?php declare(strict_types=1);
/** @var string|null $error */
/** @var array $row */
/** @var string $csrf */
$bp = base_path();
$isFree = (($row['code'] ?? '') === 'FREE');
?>

<div class="d-flex align-items-center justify-content-between mb-3">
  <h3 class="mb-0">Editar plan</h3>
  <a class="btn btn-outline-secondary" href="<?= htmlspecialchars($bp . '/admin/plans') ?>">Volver</a>
</div>

<?php if (!empty($error)): ?>
  <div class="alert alert-danger"><?= htmlspecialchars((string)$error) ?></div>
<?php endif; ?>

<div class="card">
  <div class="card-body">
    <form method="post" action="<?= htmlspecialchars($bp . '/admin/plans/edit') ?>" class="row g-3">
      <input type="hidden" name="_csrf" value="<?= htmlspecialchars($csrf) ?>">
      <input type="hidden" name="id" value="<?= (int)$row['id'] ?>">

      <div class="col-md-4">
        <label class="form-label">Code</label>
        <input class="form-control" name="code"
               value="<?= htmlspecialchars((string)($row['code'] ?? '')) ?>"
               <?= $isFree ? 'readonly' : '' ?>
               required>
        <?php if ($isFree): ?>
          <div class="form-text text-warning">El plan FREE no permite cambiar su code.</div>
        <?php else: ?>
          <div class="form-text">MAYÚSCULAS, números o _ (2 a 50).</div>
        <?php endif; ?>
      </div>

      <div class="col-md-8">
        <label class="form-label">Nombre</label>
        <input class="form-control" name="nombre"
               value="<?= htmlspecialchars((string)($row['nombre'] ?? '')) ?>"
               required>
      </div>

      <div class="col-12">
        <label class="form-label">Descripción</label>
        <textarea class="form-control" name="descripcion" rows="2"
                  placeholder="Opcional"><?= htmlspecialchars((string)($row['descripcion'] ?? '')) ?></textarea>
      </div>

      <div class="col-md-4">
        <label class="form-label">Precio mensual</label>
        <input class="form-control" name="precio_mensual"
               value="<?= htmlspecialchars((string)($row['precio_mensual'] ?? '0.00')) ?>"
               required>
      </div>

      <div class="col-md-4">
        <label class="form-label">Precio anual</label>
        <input class="form-control" name="precio_anual"
               value="<?= htmlspecialchars((string)($row['precio_anual'] ?? '0.00')) ?>"
               required>
      </div>

      <div class="col-md-4">
        <label class="form-label">Estado</label>
        <select class="form-select" name="estado">
          <option value="activo" <?= (($row['estado'] ?? 'activo')==='activo'?'selected':'') ?>>Activo</option>
          <option value="inactivo" <?= (($row['estado'] ?? 'activo')==='inactivo'?'selected':'') ?>>Inactivo</option>
        </select>
      </div>

      <div class="col-12">
        <button class="btn btn-primary" type="submit">Guardar cambios</button>
        <a class="btn btn-light" href="<?= htmlspecialchars($bp . '/admin/plans') ?>">Cancelar</a>
      </div>
    </form>
  </div>
</div>
