<?php declare(strict_types=1);
/** @var array $plan */
/** @var array $modules */
/** @var string|null $error */
/** @var string $csrf */
$bp = base_path();
?>

<div class="d-flex flex-wrap align-items-center justify-content-between mb-3 gap-2">
  <div>
    <h3 class="mb-1">Plan → Módulos</h3>
    <div class="text-muted small">
      Plan: <span class="fw-semibold"><?= htmlspecialchars((string)$plan['nombre']) ?></span>
      (<?= htmlspecialchars((string)$plan['code']) ?>) — Estado:
      <?php if (($plan['estado'] ?? '') === 'activo'): ?>
        <span class="badge text-bg-success">Activo</span>
      <?php else: ?>
        <span class="badge text-bg-secondary">Inactivo</span>
      <?php endif; ?>
    </div>
  </div>

  <div class="d-flex gap-2">
    <a class="btn btn-outline-secondary" href="<?= htmlspecialchars($bp . '/admin/plans') ?>">
      <i class="bi bi-arrow-left"></i> Volver
    </a>
    <button form="pmForm" class="btn btn-primary" type="submit">
      <i class="bi bi-save"></i> Guardar
    </button>
  </div>
</div>

<?php if (!empty($error)): ?>
  <div class="alert alert-danger"><?= htmlspecialchars((string)$error) ?></div>
<?php endif; ?>

<div class="card">
  <div class="card-body p-0">
    <form id="pmForm" method="post" action="<?= htmlspecialchars($bp . '/admin/plans/modules/save') ?>">
      <input type="hidden" name="_csrf" value="<?= htmlspecialchars($csrf) ?>">
      <input type="hidden" name="plan_id" value="<?= (int)$plan['id'] ?>">

      <div class="table-responsive">
        <table class="table table-striped align-middle mb-0">
          <thead class="table-light">
            <tr>
              <th style="width:110px;">Habilitado</th>
              <th>Code</th>
              <th>Nombre</th>
              <th style="width:140px;">Scope</th>
              <th style="width:120px;">Estado</th>
            </tr>
          </thead>
          <tbody>
          <?php if (empty($modules)): ?>
            <tr>
              <td colspan="5" class="text-center text-muted py-4">No hay módulos registrados.</td>
            </tr>
          <?php else: ?>
            <?php foreach ($modules as $m): ?>
              <?php
                $mid = (int)$m['id'];
                $checked = ((int)($m['enabled'] ?? 0) === 1);
                $scope = (string)($m['scope'] ?? 'platform');
                $estado = (string)($m['estado'] ?? 'activo');
              ?>
              <tr>
                <td>
                  <div class="form-check form-switch ms-2">
                    <input class="form-check-input"
                           type="checkbox"
                           name="modules[]"
                           value="<?= $mid ?>"
                           <?= $checked ? 'checked' : '' ?>>
                  </div>
                </td>
                <td class="fw-semibold"><?= htmlspecialchars((string)$m['code']) ?></td>
                <td>
                  <div class="fw-semibold"><?= htmlspecialchars((string)$m['nombre']) ?></div>
                  <?php if (!empty($m['descripcion'])): ?>
                    <div class="small text-muted"><?= htmlspecialchars((string)$m['descripcion']) ?></div>
                  <?php endif; ?>
                </td>
                <td>
                  <?php if ($scope === 'platform'): ?>
                    <span class="badge text-bg-dark">platform</span>
                  <?php elseif ($scope === 'empresa'): ?>
                    <span class="badge text-bg-primary">empresa</span>
                  <?php elseif ($scope === 'postulante'): ?>
                    <span class="badge text-bg-info">postulante</span>
                  <?php else: ?>
                    <span class="badge text-bg-secondary">public</span>
                  <?php endif; ?>
                </td>
                <td>
                  <?php if ($estado === 'activo'): ?>
                    <span class="badge text-bg-success">activo</span>
                  <?php else: ?>
                    <span class="badge text-bg-secondary">inactivo</span>
                  <?php endif; ?>
                </td>
              </tr>
            <?php endforeach; ?>
          <?php endif; ?>
          </tbody>
        </table>
      </div>

      <div class="p-3 border-top d-flex justify-content-between">
        <div class="small text-muted">
          Se guardan únicamente los módulos habilitados (sin fila = deshabilitado).
        </div>
        <button class="btn btn-primary" type="submit">
          <i class="bi bi-save"></i> Guardar cambios
        </button>
      </div>
    </form>
  </div>
</div>
