<?php declare(strict_types=1);
/** @var array $items */
/** @var string|null $error */
$error = $error ?? null;
$bp = base_path();
?>

<div class="d-flex align-items-center justify-content-between mb-3">
  <div>
    <h3 class="mb-0">Roles</h3>
    <div class="text-secondary small">Catálogo de roles del sistema (base para asignación de permisos).</div>
  </div>
  <a class="btn btn-primary" href="<?= htmlspecialchars($bp . '/admin/roles/create') ?>">
    + Nuevo rol
  </a>
</div>

<?php if ($error): ?>
  <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
<?php endif; ?>

<div class="card">
  <div class="table-responsive">
    <table class="table table-striped mb-0 align-middle">
      <thead>
        <tr>
          <th style="width:80px">ID</th>
          <th style="width:180px">Code</th>
          <th>Nombre</th>
          <th>Descripción</th>
          <th style="width:130px">Estado</th>
          <th style="width:220px">Acciones</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($items as $it): ?>
          <tr>
            <td><?= (int)$it['id'] ?></td>
            <td><code><?= htmlspecialchars((string)$it['code']) ?></code></td>
            <td><?= htmlspecialchars((string)$it['nombre']) ?></td>
            <td class="text-secondary"><?= htmlspecialchars((string)($it['descripcion'] ?? '')) ?></td>
            <td>
              <?php if (($it['estado'] ?? '') === 'activo'): ?>
                <span class="badge bg-success">Activo</span>
              <?php else: ?>
                <span class="badge bg-secondary">Inactivo</span>
              <?php endif; ?>
            </td>
            <td class="d-flex gap-2">
              <a class="btn btn-sm btn-outline-primary"
                 href="<?= htmlspecialchars($bp . '/admin/roles/edit?id=' . (int)$it['id']) ?>">
                Editar
              </a>

              <form method="post" action="<?= htmlspecialchars($bp . '/admin/roles/delete') ?>"
                    onsubmit="return confirm('¿Eliminar rol?');">
                <input type="hidden" name="_csrf" value="<?= htmlspecialchars((string)($csrf ?? '')) ?>">
                <input type="hidden" name="id" value="<?= (int)$it['id'] ?>">
                <button class="btn btn-sm btn-outline-danger" type="submit">Eliminar</button>
              </form>
            </td>
          </tr>
        <?php endforeach; ?>

        <?php if (!$items): ?>
          <tr>
            <td colspan="6" class="text-center text-secondary py-4">
              No hay roles todavía.
            </td>
          </tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>
