<?php declare(strict_types=1);
/** @var array $role */
/** @var array $items */
/** @var string|null $error */
/** @var string $csrf */
$bp = base_path();
?>

<div class="d-flex flex-wrap align-items-center justify-content-between mb-3 gap-2">
  <div>
    <h3 class="mb-1">Rol → Permisos</h3>
    <div class="text-muted small">
      Rol: <span class="fw-semibold"><?= htmlspecialchars((string)$role['nombre']) ?></span>
      (<code><?= htmlspecialchars((string)$role['code']) ?></code>)
      —
      <?php if (($role['estado'] ?? '') === 'activo'): ?>
        <span class="badge text-bg-success">activo</span>
      <?php else: ?>
        <span class="badge text-bg-secondary">inactivo</span>
      <?php endif; ?>
    </div>
  </div>

  <div class="d-flex gap-2">
    <a class="btn btn-outline-secondary" href="<?= htmlspecialchars($bp . '/admin/roles') ?>">
      <i class="bi bi-arrow-left"></i> Volver
    </a>
    <button form="rpForm" class="btn btn-primary" type="submit">
      <i class="bi bi-save"></i> Guardar
    </button>
  </div>
</div>

<?php if (!empty($error)): ?>
  <div class="alert alert-danger"><?= htmlspecialchars((string)$error) ?></div>
<?php endif; ?>

<div class="card">
  <div class="card-body p-0">
    <form id="rpForm" method="post" action="<?= htmlspecialchars($bp . '/admin/roles/permissions/save') ?>">
      <input type="hidden" name="_csrf" value="<?= htmlspecialchars($csrf) ?>">
      <input type="hidden" name="role_id" value="<?= (int)$role['id'] ?>">

      <div class="table-responsive">
        <table class="table table-striped align-middle mb-0">
          <thead class="table-light">
            <tr>
              <th style="width:110px;">Asignado</th>
              <th style="width:240px;">Code</th>
              <th>Nombre</th>
              <th>Descripción</th>
            </tr>
          </thead>
          <tbody>
          <?php if (empty($items)): ?>
            <tr>
              <td colspan="4" class="text-center text-muted py-4">No hay permisos registrados.</td>
            </tr>
          <?php else: ?>
            <?php foreach ($items as $p): ?>
              <?php
                $pid = (int)$p['id'];
                $checked = ((int)($p['assigned'] ?? 0) === 1);
              ?>
              <tr>
                <td>
                  <div class="form-check form-switch ms-2">
                    <input class="form-check-input"
                           type="checkbox"
                           name="permissions[]"
                           value="<?= $pid ?>"
                           <?= $checked ? 'checked' : '' ?>>
                  </div>
                </td>
                <td><code><?= htmlspecialchars((string)$p['code']) ?></code></td>
                <td class="fw-semibold"><?= htmlspecialchars((string)$p['nombre']) ?></td>
                <td class="text-muted"><?= htmlspecialchars((string)($p['descripcion'] ?? '')) ?></td>
              </tr>
            <?php endforeach; ?>
          <?php endif; ?>
          </tbody>
        </table>
      </div>

      <div class="p-3 border-top d-flex justify-content-between">
        <div class="small text-muted">
          Se guarda el set completo: lo no marcado queda sin asignación.
        </div>
        <button class="btn btn-primary" type="submit">
          <i class="bi bi-save"></i> Guardar cambios
        </button>
      </div>
    </form>
  </div>
</div>
