<?php declare(strict_types=1);
/** @var array $items */
/** @var string $q */
/** @var string|null $error */
$bp = base_path();
?>

<div class="d-flex flex-wrap align-items-center justify-content-between mb-3 gap-2">
  <div>
    <h3 class="mb-1">Usuarios</h3>
    <div class="text-muted small">Asignación de roles por usuario.</div>
  </div>

  <form class="d-flex gap-2" method="get" action="<?= htmlspecialchars($bp . '/admin/users') ?>">
    <input class="form-control" name="q" value="<?= htmlspecialchars((string)$q) ?>" placeholder="Buscar por email o nombre">
    <button class="btn btn-outline-secondary" type="submit">Buscar</button>
  </form>
</div>

<?php if (!empty($error)): ?>
  <div class="alert alert-danger"><?= htmlspecialchars((string)$error) ?></div>
<?php endif; ?>

<div class="card">
  <div class="table-responsive">
    <table class="table table-striped mb-0 align-middle">
      <thead class="table-light">
        <tr>
          <th style="width:80px">ID</th>
          <th>Email</th>
          <th>Nombre</th>
          <th style="width:130px">Tipo</th>
          <th style="width:130px">Estado</th>
          <th style="width:140px">Verificado</th>
          <th style="width:160px">Acciones</th>
        </tr>
      </thead>
      <tbody>
        <?php if (empty($items)): ?>
          <tr>
            <td colspan="7" class="text-center text-muted py-4">No hay usuarios.</td>
          </tr>
        <?php else: ?>
          <?php foreach ($items as $u): ?>
            <tr>
              <td><?= (int)$u['id'] ?></td>
              <td class="fw-semibold"><?= htmlspecialchars((string)$u['email']) ?></td>
              <td><?= htmlspecialchars((string)($u['nombre'] ?? '')) ?></td>
              <td><span class="badge text-bg-dark"><?= htmlspecialchars((string)$u['tipo']) ?></span></td>
              <td>
                <?php if (($u['estado'] ?? '') === 'activo'): ?>
                  <span class="badge text-bg-success">activo</span>
                <?php elseif (($u['estado'] ?? '') === 'bloqueado'): ?>
                  <span class="badge text-bg-danger">bloqueado</span>
                <?php else: ?>
                  <span class="badge text-bg-secondary">pendiente</span>
                <?php endif; ?>
              </td>
              <td>
                <?php if ((int)($u['email_verificado'] ?? 0) === 1): ?>
                  <span class="badge text-bg-success">sí</span>
                <?php else: ?>
                  <span class="badge text-bg-secondary">no</span>
                <?php endif; ?>
              </td>
              <td>
                <a class="btn btn-sm btn-outline-secondary"
                   href="<?= htmlspecialchars($bp . '/admin/users/roles?user_id=' . (int)$u['id']) ?>">
                  <i class="bi bi-person-gear"></i> Roles
                </a>
              </td>
            </tr>
          <?php endforeach; ?>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>
