<?php declare(strict_types=1);
/** @var array $user */
/** @var array $roles */
/** @var string|null $error */
/** @var string $csrf */
$bp = base_path();
?>

<div class="d-flex flex-wrap align-items-center justify-content-between mb-3 gap-2">
  <div>
    <h3 class="mb-1">Usuario → Roles</h3>
    <div class="text-muted small">
      Usuario: <span class="fw-semibold"><?= htmlspecialchars((string)$user['email']) ?></span>
      <?php if (!empty($user['nombre'])): ?>
        — <?= htmlspecialchars((string)$user['nombre']) ?>
      <?php endif; ?>
      — <span class="badge text-bg-dark"><?= htmlspecialchars((string)$user['tipo']) ?></span>
    </div>
  </div>

  <div class="d-flex gap-2">
    <a class="btn btn-outline-secondary" href="<?= htmlspecialchars($bp . '/admin/users') ?>">
      <i class="bi bi-arrow-left"></i> Volver
    </a>
    <button form="urForm" class="btn btn-primary" type="submit">
      <i class="bi bi-save"></i> Guardar
    </button>
  </div>
</div>

<?php if (!empty($error)): ?>
  <div class="alert alert-danger"><?= htmlspecialchars((string)$error) ?></div>
<?php endif; ?>

<div class="card">
  <div class="card-body p-0">
    <form id="urForm" method="post" action="<?= htmlspecialchars($bp . '/admin/users/roles/save') ?>">
      <input type="hidden" name="_csrf" value="<?= htmlspecialchars($csrf) ?>">
      <input type="hidden" name="user_id" value="<?= (int)$user['id'] ?>">

      <div class="table-responsive">
        <table class="table table-striped align-middle mb-0">
          <thead class="table-light">
            <tr>
              <th style="width:110px;">Asignado</th>
              <th style="width:220px;">Code</th>
              <th>Nombre</th>
              <th>Descripción</th>
              <th style="width:120px;">Estado</th>
            </tr>
          </thead>
          <tbody>
          <?php if (empty($roles)): ?>
            <tr>
              <td colspan="5" class="text-center text-muted py-4">No hay roles registrados.</td>
            </tr>
          <?php else: ?>
            <?php foreach ($roles as $r): ?>
              <?php
                $rid = (int)$r['id'];
                $checked = ((int)($r['assigned'] ?? 0) === 1);
                $disabled = ((int)$user['id'] === 1 && (string)$r['code'] === 'super_admin'); // coherente con protección del service
              ?>
              <tr>
                <td>
                  <div class="form-check form-switch ms-2">
                    <input class="form-check-input"
                           type="checkbox"
                           name="roles[]"
                           value="<?= $rid ?>"
                           <?= $checked ? 'checked' : '' ?>
                           <?= $disabled ? 'disabled' : '' ?>>
                  </div>
                </td>
                <td><code><?= htmlspecialchars((string)$r['code']) ?></code></td>
                <td class="fw-semibold"><?= htmlspecialchars((string)$r['nombre']) ?></td>
                <td class="text-muted"><?= htmlspecialchars((string)($r['descripcion'] ?? '')) ?></td>
                <td>
                  <?php if (($r['estado'] ?? '') === 'activo'): ?>
                    <span class="badge text-bg-success">activo</span>
                  <?php else: ?>
                    <span class="badge text-bg-secondary">inactivo</span>
                  <?php endif; ?>
                </td>
              </tr>
            <?php endforeach; ?>
          <?php endif; ?>
          </tbody>
        </table>
      </div>

      <div class="p-3 border-top d-flex justify-content-between">
        <div class="small text-muted">
          Se guarda el set completo (user_roles). assigned_at se genera automáticamente.
        </div>
        <button class="btn btn-primary" type="submit">
          <i class="bi bi-save"></i> Guardar cambios
        </button>
      </div>
    </form>
  </div>
</div>
