<?php
/** @var array $categorias */
/** @var array $boosts */
/** @var string $csrf */
/** @var string|null $ok */
/** @var string|null $error */

$bp = base_path();
?>

<div class="container py-4">
  <div class="d-flex align-items-center justify-content-between mb-3">
    <div>
      <h3 class="mb-0">Publicitar / Potenciar publicaciones</h3>
      <div class="text-muted small">
        Aumenta visibilidad en el feed según categorías laborales. Compatible con postulantes y matching por categorías.
      </div>
    </div>
  </div>

  <?php if (!empty($ok)): ?>
    <div class="alert alert-success"><?= htmlspecialchars((string)$ok) ?></div>
  <?php endif; ?>

  <?php if (!empty($error)): ?>
    <div class="alert alert-danger"><?= htmlspecialchars((string)$error) ?></div>
  <?php endif; ?>

  <div class="card mb-3">
    <div class="card-body">
      <h5 class="mb-3">Crear nuevo boost</h5>

      <form method="post" action="<?= htmlspecialchars($bp . '/empresa/boosts/create') ?>">
        <input type="hidden" name="_csrf" value="<?= htmlspecialchars($csrf) ?>">

        <div class="row g-3">
          <div class="col-md-4">
            <label class="form-label">Alcance</label>
            <select name="scope" class="form-select">
              <option value="para_ti">Solo postulantes compatibles</option>
              <option value="global">Todos (global)</option>
            </select>
          </div>

          <div class="col-md-4">
            <label class="form-label">Categoría</label>
            <select name="categoria_id" class="form-select">
              <option value="0">Todas las categorías</option>
              <?php foreach (($categorias ?? []) as $c): ?>
                <option value="<?= (int)($c['id'] ?? 0) ?>">
                  <?= htmlspecialchars((string)($c['nombre'] ?? '')) ?>
                </option>
              <?php endforeach; ?>
            </select>
          </div>

          <div class="col-md-2">
            <label class="form-label">Días</label>
            <input type="number" name="days" class="form-control" value="7" min="1" max="30">
          </div>

          <div class="col-md-2">
            <label class="form-label">Potencia</label>
            <select name="score_boost" class="form-select">
              <option value="300">Normal</option>
              <option value="600" selected>Alta</option>
              <option value="1000">Máxima</option>
            </select>
          </div>
        </div>

        <div class="mt-3">
          <button class="btn btn-primary">Activar boost</button>
        </div>
      </form>
    </div>
  </div>

  <div class="card">
    <div class="card-body p-0">
      <?php if (empty($boosts)): ?>
        <div class="p-4 text-center text-muted">No hay boosts activos.</div>
      <?php else: ?>
        <div class="table-responsive">
          <table class="table table-striped table-hover align-middle mb-0">
            <thead>
              <tr>
                <th>Scope</th>
                <th>Categoría</th>
                <th>Potencia</th>
                <th>Hasta</th>
                <th class="text-end">Acción</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($boosts as $b): ?>
                <tr>
                  <td><?= htmlspecialchars((string)($b['scope'] ?? '')) ?></td>
                  <td><?= htmlspecialchars((string)($b['categoria_nombre'] ?? 'Todas')) ?></td>
                  <td><?= (int)($b['score_boost'] ?? 0) ?></td>
                  <td><?= htmlspecialchars((string)($b['ends_at'] ?? '')) ?></td>
                  <td class="text-end">
                    <form method="post" action="<?= htmlspecialchars($bp . '/empresa/boosts/disable') ?>" class="d-inline">
                      <input type="hidden" name="_csrf" value="<?= htmlspecialchars($csrf) ?>">
                      <input type="hidden" name="id" value="<?= (int)($b['id'] ?? 0) ?>">
                      <button class="btn btn-sm btn-outline-danger">Desactivar</button>
                    </form>
                  </td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      <?php endif; ?>
    </div>
  </div>
</div>
