<?php
/** @var array $empresa */
/** @var array $perfil */
/** @var array $rep */
/** @var array $stats */

$bp = base_path();
$nombre = (string)($empresa['nombre'] ?? 'Empresa');
?>
<div class="card">
  <div class="card-body">
    <div class="d-flex align-items-start justify-content-between gap-3">
      <div>
        <h4 class="mb-1"><?= e($nombre) ?></h4>
        <div class="text-muted small">
          Reputación: <span class="fw-semibold"><?= e((string)$rep['score']) ?>/10</span>
          • <?= e((string)$rep['label']) ?> — <?= e((string)$rep['hint']) ?>
          • Base: <?= (int)$rep['T'] ?> reacciones
        </div>
      </div>
      <div class="text-end">
        <a class="btn btn-outline-primary btn-sm" href="<?= e($bp) ?>/empresa/perfil">Editar perfil</a>
      </div>
    </div>

    <hr>

    <div class="row g-3">
      <div class="col-6 col-lg-3">
        <div class="p-3 border rounded-3 bg-light">
          <div class="text-muted small">Vacantes</div>
          <div class="fs-4 fw-bold"><?= (int)($stats['vacantes_total'] ?? 0) ?></div>
        </div>
      </div>
      <div class="col-6 col-lg-3">
        <div class="p-3 border rounded-3 bg-light">
          <div class="text-muted small">Publicadas</div>
          <div class="fs-4 fw-bold"><?= (int)($stats['vacantes_publicadas'] ?? 0) ?></div>
        </div>
      </div>
      <div class="col-6 col-lg-3">
        <div class="p-3 border rounded-3 bg-light">
          <div class="text-muted small">Postulaciones</div>
          <div class="fs-4 fw-bold"><?= (int)($stats['postulaciones_total'] ?? 0) ?></div>
        </div>
      </div>
      <div class="col-6 col-lg-3">
        <div class="p-3 border rounded-3 bg-light">
          <div class="text-muted small">Boosts activos</div>
          <div class="fs-4 fw-bold"><?= (int)($stats['boosts_activos'] ?? 0) ?></div>
        </div>
      </div>
    </div>
  </div>
</div>
