<?php
/** @var array $vacantes */
/** @var string $csrf */

$bp = base_path();
$vacantes = is_array($vacantes) ? $vacantes : [];
?>

<div class="container py-4">
  <div class="d-flex align-items-center justify-content-between mb-3">
    <div>
      <h3 class="mb-0">Postulaciones</h3>
      <div class="text-muted small">Selecciona una vacante para ver sus postulaciones.</div>
    </div>
    <a class="btn btn-outline-secondary" href="<?= htmlspecialchars($bp . '/empresa/vacantes') ?>">Mis vacantes</a>
  </div>

  <?php if (empty($vacantes)): ?>
    <div class="alert alert-light border">No tienes vacantes aún.</div>
  <?php else: ?>
    <div class="row g-3">
      <?php foreach ($vacantes as $v): ?>
        <?php
          $id = (int)($v['id'] ?? 0);
          $titulo = (string)($v['titulo'] ?? '');
          $estado = (string)($v['estado'] ?? '—');
        ?>
        <div class="col-12 col-md-6 col-lg-4">
          <div class="card h-100">
            <div class="card-body">
              <div class="fw-semibold mb-1"><?= htmlspecialchars($titulo !== '' ? $titulo : ('Vacante #' . $id)) ?></div>
              <div class="small text-muted">Estado: <?= htmlspecialchars($estado) ?></div>
            </div>
            <div class="card-footer bg-white border-0 pt-0">
              <a class="btn btn-sm btn-primary w-100"
                 href="<?= htmlspecialchars($bp . '/empresa/postulaciones?vacante_id=' . $id) ?>">
                Ver postulaciones
              </a>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  <?php endif; ?>
</div>
