<?php
/** @var array $tree */
/** @var array $selected */
/** @var string $csrf */
/** @var int $userId */

$bp = base_path();
$sel = array_flip(array_map('intval', $selected));
?>

<div class="container py-3">
  <div class="app-card p-3 mb-3">
    <div class="d-flex justify-content-between align-items-start">
      <div>
        <div class="fw-semibold">Tus roles / intereses</div>
        <div class="small app-muted">Esto alimenta “Para ti” en el feed y permite filtros de alta precisión.</div>
      </div>
      <a class="btn btn-outline-secondary btn-sm" href="<?= htmlspecialchars($bp . '/feed') ?>">Volver al feed</a>
    </div>
  </div>

  <form method="post" action="<?= htmlspecialchars($bp . '/postulante/roles/guardar') ?>">
    <input type="hidden" name="_csrf" value="<?= htmlspecialchars($csrf) ?>">

    <div class="row g-3">
      <div class="col-12 col-lg-8">
        <?php foreach ($tree as $root): ?>
          <div class="app-card p-3 mb-3">
            <div class="fw-semibold mb-2"><?= htmlspecialchars($root['root']['nombre']) ?></div>

            <?php foreach ($root['familias'] as $fam): ?>
              <div class="border rounded-3 p-3 mb-2" style="border-color:#e8eefc;">
                <div class="fw-semibold mb-2"><?= htmlspecialchars($fam['familia']['nombre']) ?></div>

                <div class="row g-2">
                  <?php foreach ($fam['roles'] as $role): ?>
                    <?php $rid = (int)$role['id']; ?>
                    <div class="col-12 col-md-6">
                      <label class="d-flex gap-2 align-items-start">
                        <input class="form-check-input mt-1"
                               type="checkbox"
                               name="roles[]"
                               value="<?= $rid ?>"
                               <?= isset($sel[$rid]) ? 'checked' : '' ?>>
                        <span class="small">
                          <?= htmlspecialchars($role['nombre']) ?>
                        </span>
                      </label>
                    </div>
                  <?php endforeach; ?>
                </div>
              </div>
            <?php endforeach; ?>

          </div>
        <?php endforeach; ?>
      </div>

      <div class="col-12 col-lg-4">
        <div class="app-card p-3">
          <div class="fw-semibold mb-2">Consejo rápido</div>
          <div class="small app-muted mb-3">
            Seleccioná 3–10 roles máximo para que el feed sea preciso.
          </div>
          <button class="btn btn-primary w-100" type="submit">Guardar roles</button>
        </div>
      </div>
    </div>
  </form>
</div>
