<?php
declare(strict_types=1);
/** @var string $pageTitle */
/** @var string $content */
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($pageTitle) ?></title>
  <meta name="description" content="<?= htmlspecialchars($GLOBALS['APP_CONFIG']['seo']['default_description'] ?? '') ?>">

  <link rel="icon" href="/assets/img/favicon.ico">

  <!-- Bootstrap 5 -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

</head>
<body style="background:#f6f8ff;">
  <nav class="navbar navbar-expand-lg bg-white border-bottom">
    <div class="container">
      <a class="navbar-brand fw-semibold" href="/">Red Laboral</a>
      <div class="ms-auto d-flex gap-2">
        <a class="btn btn-outline-primary btn-sm" href="/public/login">Entrar</a>
        <a class="btn btn-primary btn-sm" href="/public/registro">Crear cuenta</a>
      </div>
    </div>
  </nav>

  <?= $content ?>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
