<?php
declare(strict_types=1);
/** @var string $pageTitle */
/** @var string $content */
/** @var string $sidebar */
/** @var string $topHint */
/** @var int|null $currentUserId */

$bp = base_path();
$topHint = $topHint ?? 'Panel';
$currentUserId = (int)($currentUserId ?? 0);
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= e($pageTitle) ?></title>

  <link rel="icon" href="<?= e($bp) ?>/assets/img/favicon.ico">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

  <style>
    :root{
      --app-bg:#f6f8ff; --card:#fff; --stroke:#e8eefc; --ink:#0b1220;
      --muted:#5b6b86; --primary:#245bff; --side:#0b1220;
    }
    body{ background:var(--app-bg); color:var(--ink); }

    .topbar{
      position:sticky; top:0; z-index:30;
      background:rgba(255,255,255,.92);
      backdrop-filter: blur(8px);
      border-bottom:1px solid var(--stroke);
    }
    .brand-chip{
      background:#eef3ff;border:1px solid var(--stroke);
      font-weight:800;color:var(--primary);
      border-radius:14px;padding:.55rem .9rem;
    }

    .panel-shell{ padding:16px 0 86px; }
    .side{
      background: linear-gradient(180deg, #0b1220, #101a33);
      border:1px solid rgba(255,255,255,.08);
      border-radius:18px;
      padding:14px;
      color:#fff;
      position:sticky; top:92px;
    }
    .side a{
      color:#c9d4ff; text-decoration:none;
      display:flex; align-items:center; gap:10px;
      padding:10px 12px; border-radius:14px;
    }
    .side a:hover{ background: rgba(255,255,255,.06); }
    .side .active{ background: rgba(36,91,255,.22); color:#fff; }

    .app-card{
      background:var(--card);
      border:1px solid var(--stroke);
      border-radius:16px;
    }

    .bottom-nav{
      position:fixed; bottom:0; left:0; right:0; z-index:40;
      background:rgba(255,255,255,0.96);
      backdrop-filter: blur(8px);
      border-top:1px solid var(--stroke);
      padding:10px 14px;
      display:none;
    }
    .bottom-nav a{
      text-decoration:none; color:var(--muted);
      font-size:12px; display:flex; flex-direction:column;
      align-items:center; gap:4px;
    }
    .bottom-nav .dot{
      width:44px;height:44px;border-radius:14px;
      background:#f1f5ff;border:1px solid var(--stroke);
      display:flex;align-items:center;justify-content:center;
      color:var(--primary); font-weight:800;
    }
    @media (max-width: 992px){
      .side-wrap{ display:none; }
      .bottom-nav{ display:flex; justify-content:space-between; }
    }
  </style>
</head>
<body>

  <div class="topbar">
    <div class="container py-3 d-flex align-items-center justify-content-between">
      <div class="d-flex align-items-center gap-2">
        <div class="brand-chip">JOB</div>
        <div>
          <div class="fw-semibold" style="line-height:1.1;"><?= e($pageTitle) ?></div>
          <div class="small text-muted"><?= e($topHint) ?></div>
        </div>
      </div>

      <div class="d-flex gap-2">
        <a class="btn btn-outline-primary btn-sm" href="<?= e($bp) ?>/feed">Ir al feed</a>
        <a class="btn btn-outline-secondary btn-sm" href="<?= e($bp) ?>/logout">Salir</a>
      </div>
    </div>
  </div>

  <main class="panel-shell">
    <div class="container">
      <div class="row g-3">
        <div class="col-12 col-lg-3 side-wrap">
          <div class="side">
            <?= $sidebar ?>
          </div>
        </div>
        <div class="col-12 col-lg-9">
          <?= $content ?>
        </div>
      </div>
    </div>
  </main>

  <nav class="bottom-nav">
    <a href="<?= e($bp) ?>/feed"><span class="dot">🏠</span><span>Feed</span></a>
    <a href="<?= e($bp) ?>/empresa"><span class="dot">🏢</span><span>Panel</span></a>
    <a href="<?= e($bp) ?>/empresa/boosts"><span class="dot">⚡</span><span>Boost</span></a>
    <a href="<?= e($bp) ?>/empresa/notificaciones"><span class="dot">🔔</span><span>Alertas</span></a>
    <a href="<?= e($bp) ?>/empresas/ver?id=<?= (int)$currentUserId ?>"><span class="dot">👤</span><span>Perfil</span></a>
  </nav>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
