<?php
declare(strict_types=1);
/**
 * Partial: Ideales para ti
 * Variables:
 * - array  $ideales
 * - string $bp
 * - string $csrf
 * - string $view  ('desktop'|'mobile')
 */

$ideales = is_array($ideales) ? $ideales : [];
$view = (string)($view ?? 'desktop');

if (empty($ideales)) return;

// desktop: max 3; mobile: max 5
$max = $view === 'mobile' ? 5 : 3;
$ideales = array_slice($ideales, 0, $max);

?>

<?php if ($view === 'mobile'): ?>
  <div class="app-card p-3 mb-3">
    <div class="fw-semibold mb-2">Ideales para ti</div>
    <div class="small app-muted mb-3">Patrocinadas por empresas y profesionales (según tus categorías).</div>

    <div id="idealCarousel" class="carousel slide" data-bs-ride="carousel">
      <div class="carousel-inner">
        <?php foreach ($ideales as $i => $it): ?>
          <div class="carousel-item <?= $i === 0 ? 'active' : '' ?>">
            <?= render_template('partials/vacante_card.php', [
              'it' => $it,
              'tipo' => 'postulante',
              'bp' => $bp,
              'csrf' => $csrf,
            ]) ?>
          </div>
        <?php endforeach; ?>
      </div>
      <button class="carousel-control-prev" type="button" data-bs-target="#idealCarousel" data-bs-slide="prev">
        <span class="carousel-control-prev-icon" aria-hidden="true"></span>
        <span class="visually-hidden">Anterior</span>
      </button>
      <button class="carousel-control-next" type="button" data-bs-target="#idealCarousel" data-bs-slide="next">
        <span class="carousel-control-next-icon" aria-hidden="true"></span>
        <span class="visually-hidden">Siguiente</span>
      </button>
    </div>
  </div>

<?php else: ?>
  <div class="app-card p-3 mt-3">
    <div class="fw-semibold mb-2">Ideales para ti</div>
    <div class="small app-muted mb-2">Patrocinadas (prioriza match + boost).</div>
    <?php foreach ($ideales as $it): ?>
      <div class="mb-3">
        <?= render_template('partials/vacante_card_mini.php', [
          'it' => $it,
          'bp' => $bp,
        ]) ?>
      </div>
    <?php endforeach; ?>
  </div>
<?php endif; ?>
