<?php
/** @var array  $it */
/** @var string $tipo */
/** @var string $bp */
/** @var string $csrf */

if (!function_exists('feed_asset_url')) {
  function feed_asset_url(string $bp, ?string $path): string {
    $p = trim((string)$path);
    if ($p === '') return '';
    $p = str_replace('\\', '/', $p);
    if (preg_match('~^https?://~i', $p)) return $p;

    if (str_starts_with($p, '/public/upload/')) $p = substr($p, 7);
    if (str_starts_with($p, 'public/upload/'))  $p = '/' . substr($p, 7);
    if (str_starts_with($p, 'upload/'))         $p = '/' . $p;
    if (!str_starts_with($p, '/')) $p = '/' . $p;

    return $bp . $p;
  }
}

if (!function_exists('feed_time_ago')) {
  function feed_time_ago(?string $dt): string {
    if (!$dt) return '—';
    try { $d = new DateTime($dt); } catch (Throwable $e) { return '—'; }
    $now = new DateTime('now');
    $sec = $now->getTimestamp() - $d->getTimestamp();
    if ($sec < 0) $sec = 0;

    if ($sec < 60) return 'hace 1 min';
    if ($sec < 3600) return 'hace ' . (int)floor($sec/60) . ' min';
    if ($sec < 86400) return 'hace ' . (int)floor($sec/3600) . ' h';

    $days = (int)floor($sec/86400);
    if ($days < 7) return 'hace ' . $days . ' día' . ($days === 1 ? '' : 's');
    $weeks = (int)floor($days/7);
    if ($weeks < 4) return 'hace ' . $weeks . ' semana' . ($weeks === 1 ? '' : 's');

    $months = (int)floor($days/30);
    if ($months < 12) return 'hace ' . $months . ' mes' . ($months === 1 ? '' : 'es');

    $years = (int)floor($days/365);
    return 'hace ' . $years . ' año' . ($years === 1 ? '' : 's');
  }
}

if (!function_exists('feed_safe_html_excerpt')) {
  function feed_safe_html_excerpt(string $html, int $maxChars = 420): string {
    $html = trim($html);
    if ($html === '') return '';

    $html = preg_replace('~<(script|iframe|object|embed|style)\b[^>]*>.*?</\1>~is', '', $html) ?? '';
    $allowed = '<p><br><b><strong><i><em><ul><ol><li><a><blockquote><code><pre>';
    $clean = strip_tags($html, $allowed);

    $clean = preg_replace('~\son\w+\s*=\s*(".*?"|\'.*?\'|[^\s>]+)~i', '', $clean) ?? '';
    $clean = preg_replace('~\sstyle\s*=\s*(".*?"|\'.*?\')~i', '', $clean) ?? '';

    $clean = preg_replace_callback('~<a\s+([^>]*?)href\s*=\s*("|\')(.*?)\2([^>]*)>~i', function($m){
      $before = $m[1] ?? '';
      $q = $m[2] ?? '"';
      $href = trim((string)($m[3] ?? ''));
      $after = $m[4] ?? '';
      if (preg_match('~^(javascript:|data:)~i', $href)) $href = '#';
      if ($href !== '#' && !preg_match('~^(https?://|/)~i', $href)) $href = '#';
      return '<a ' . $before . 'href=' . $q . htmlspecialchars($href, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8') . $q . $after . ' target="_blank" rel="noopener noreferrer">';
    }, $clean);

    $textOnly = trim(preg_replace('~\s+~', ' ', strip_tags($clean)));
    if (mb_strlen($textOnly, 'UTF-8') <= $maxChars) return $clean;

    $tr = mb_strimwidth($textOnly, 0, $maxChars, '…', 'UTF-8');
    return '<p>' . htmlspecialchars($tr, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8') . '</p>';
  }
}

$id     = (int)($it['id'] ?? 0);
$title  = (string)($it['titulo'] ?? 'Anuncio');
$tipoA  = (string)($it['anuncio_tipo'] ?? ($it['tipo'] ?? 'otro'));
$autor  = (string)($it['autor_nombre'] ?? 'RRHH');
$rrhhId = (int)($it['rrhh_user_id'] ?? 0);

$when   = (string)($it['fecha_feed'] ?? '');
$img    = feed_asset_url($bp, (string)($it['imagen_path'] ?? ''));

$badgeClass = match ($tipoA) {
  'servicio'   => 'primary',
  'oferta'     => 'success',
  'comunicado' => 'warning',
  'nota'       => 'info',
  'evento'     => 'danger',
  default      => 'secondary',
};

$descHtml = (string)($it['descripcion'] ?? '');
$excerpt  = feed_safe_html_excerpt($descHtml, 520);

$profileUrl = $rrhhId > 0 ? ($bp . '/rrhh/ver?id=' . $rrhhId) : '#';
?>

<div class="app-card p-3 mb-3">
  <div class="d-flex justify-content-between align-items-start gap-3">
    <div class="flex-grow-1">
      <div class="d-flex align-items-center gap-2 flex-wrap">
        <span class="badge text-bg-<?= htmlspecialchars($badgeClass) ?>"><?= htmlspecialchars(mb_strtoupper($tipoA, 'UTF-8')) ?></span>
        <div class="small text-muted"><?= htmlspecialchars(feed_time_ago($when)) ?></div>
      </div>

      <div class="mt-2 fw-semibold" style="font-size:18px; line-height:1.15;">
        <?= htmlspecialchars($title) ?>
      </div>

      <div class="small text-muted mt-1">
        Publicado por:
        <a href="<?= htmlspecialchars($profileUrl) ?>" style="text-decoration:none; font-weight:700;">
          <?= htmlspecialchars($autor) ?>
        </a>
      </div>
    </div>

    <?php if ($img !== ''): ?>
      <div style="width:120px; flex: 0 0 120px;">
        <img src="<?= htmlspecialchars($img) ?>" alt="Anuncio" class="rounded-3" style="width:120px;height:90px;object-fit:cover;border:1px solid #e8eefc;">
      </div>
    <?php endif; ?>
  </div>

  <?php if ($excerpt !== ''): ?>
    <div class="mt-3" style="color:#0b1220;">
      <?= $excerpt ?>
    </div>
  <?php endif; ?>
  
  <?php
$aid = (int)($it['id'] ?? 0);
$my  = (string)($it['my_reaction'] ?? '');
$cntLike = (int)($it['reac_like'] ?? 0);
$cntRec  = (int)($it['reac_recommend'] ?? 0);
$cntExc  = (int)($it['reac_excellent'] ?? 0);
$cntBad  = (int)($it['reac_bad'] ?? 0);
?>
<div class="vac-actions mt-3 align-items-center"
     data-social-bar="1"
     data-kind="rrhh_anuncio"
     data-id="<?= $aid ?>">

  <div class="vac-reactions" role="group" aria-label="Reacciones">
    <button type="button" class="reac-btn <?= $my==='like'?'active':'' ?>" data-action="react" data-reaction="like">
      👍 <span class="reac-count" data-k="like"><?= $cntLike ?></span>
    </button>
    <button type="button" class="reac-btn <?= $my==='recommend'?'active':'' ?>" data-action="react" data-reaction="recommend">
      ⭐ <span class="reac-count" data-k="recommend"><?= $cntRec ?></span>
    </button>
    <button type="button" class="reac-btn <?= $my==='excellent'?'active':'' ?>" data-action="react" data-reaction="excellent">
      🔥 <span class="reac-count" data-k="excellent"><?= $cntExc ?></span>
    </button>
    <button type="button" class="reac-btn <?= $my==='bad'?'active':'' ?>" data-action="react" data-reaction="bad">
      👎 <span class="reac-count" data-k="bad"><?= $cntBad ?></span>
    </button>
  </div>
</div>

  <div class="d-flex justify-content-end mt-3">
    <?php if ($rrhhId > 0): ?>
      <a class="btn btn-outline-primary btn-sm" href="<?= htmlspecialchars($profileUrl) ?>">Ver perfil RRHH</a>
    <?php endif; ?>
  </div>
</div>

