<?php
declare(strict_types=1);
/**
 * Partial: Card de vacante para el feed.
 * Variables requeridas:
 * - array  $it
 * - string $tipo
 * - string $bp
 * - string $csrf
 */

$vid = (int)($it['id'] ?? 0);

$fmtMoney = function ($mon, $smin, $smax): string {
  $mon = (string)($mon ?: 'CRC');
  if ($smin === null && $smax === null) return '—';
  $a = $smin !== null ? number_format((float)$smin, 2) : '—';
  $b = $smax !== null ? number_format((float)$smax, 2) : '—';
  return "{$mon} {$a} - {$b}";
};

$badgeEstadoPost = function (?string $estado): array {
  $estado = $estado ?? '';
  return match ($estado) {
    'enviada'      => ['secondary', 'Enviada'],
    'vista'        => ['info', 'Vista'],
    'preseleccion' => ['success', 'Preselección'],
    'rechazada'    => ['danger', 'Rechazada'],
    default        => ['light', '—'],
  };
};

$icon = function(string $name): string {
  // SVGs minimalistas (outline). IMPORTANTE: stroke/fill se controlan por CSS.
  return match ($name) {
    'bolt' => '<svg viewBox="0 0 24 24" aria-hidden="true"><path d="M13 2L3 14h7l-1 8 10-12h-7l1-8z"/></svg>',
    'badge' => '<svg viewBox="0 0 24 24" aria-hidden="true"><path d="M12 2l2.5 5 5.5.8-4 3.9.9 5.5L12 15.8 7.1 17.2l.9-5.5-4-3.9 5.5-.8L12 2z"/></svg>',
    'star' => '<svg viewBox="0 0 24 24" aria-hidden="true"><path d="M12 2l2.5 5 5.5.8-4 3.9.9 5.5L12 15.8 7.1 17.2l.9-5.5-4-3.9 5.5-.8L12 2z"/></svg>',
    'check' => '<svg viewBox="0 0 24 24" aria-hidden="true"><path d="M20 6L9 17l-5-5"/></svg>',
    'shield' => '<svg viewBox="0 0 24 24" aria-hidden="true"><path d="M12 2l8 4v6c0 5-3.3 9.3-8 10-4.7-.7-8-5-8-10V6l8-4z"/></svg>',
    'clock' => '<svg viewBox="0 0 24 24" aria-hidden="true"><path d="M12 8v5l3 2"/><path d="M12 22a10 10 0 1 0 0-20 10 10 0 0 0 0 20z"/></svg>',
    'pin' => '<svg viewBox="0 0 24 24" aria-hidden="true"><path d="M12 21s7-4.5 7-11a7 7 0 0 0-14 0c0 6.5 7 11 7 11z"/><path d="M12 10a2 2 0 1 0 0-4 2 2 0 0 0 0 4z"/></svg>',
    'briefcase' => '<svg viewBox="0 0 24 24" aria-hidden="true"><path d="M10 6V5a2 2 0 0 1 2-2h0a2 2 0 0 1 2 2v1"/><path d="M4 7h16v12a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2V7z"/></svg>',
    'layers' => '<svg viewBox="0 0 24 24" aria-hidden="true"><path d="M12 2l9 5-9 5-9-5 9-5z"/><path d="M3 12l9 5 9-5"/><path d="M3 17l9 5 9-5"/></svg>',
    'heart' => '<svg viewBox="0 0 24 24" aria-hidden="true"><path d="M12 21s-7-4.6-9.2-8.5C1 9.5 3 6 6.6 6c1.8 0 3.2 1 3.9 2 0.7-1 2.1-2 3.9-2C18 6 20 9.5 21.2 12.5 19 16.4 12 21 12 21z"/></svg>',
    'sparkle' => '<svg viewBox="0 0 24 24" aria-hidden="true"><path d="M12 2l1.3 5.2L18 9l-4.7 1.8L12 16l-1.3-5.2L6 9l4.7-1.8L12 2z"/><path d="M19 14l.7 2.7L22 18l-2.3 1.3L19 22l-.7-2.7L16 18l2.3-1.3L19 14z"/></svg>',
    'warn' => '<svg viewBox="0 0 24 24" aria-hidden="true"><path d="M12 9v4"/><path d="M12 17h.01"/><path d="M10.3 3.6a2 2 0 0 1 3.4 0l8 14A2 2 0 0 1 20 20H4a2 2 0 0 1-1.7-2.4l8-14z"/></svg>',
    'share' => '<svg viewBox="0 0 24 24" aria-hidden="true"><path d="M16 8a3 3 0 1 0-2.8-4"/><path d="M6 14a3 3 0 1 0 0 6 3 3 0 0 0 0-6z"/><path d="M18 11a3 3 0 1 0 0 6 3 3 0 0 0 0-6z"/><path d="M8.6 15.5l6.8-3.6"/><path d="M8.6 18.5l6.8 3.6"/></svg>',
        'eye' => '<svg viewBox="0 0 24 24" aria-hidden="true">
      <path d="M2 12s3.5-7 10-7 10 7 10 7-3.5 7-10 7S2 12 2 12z"></path>
      <path d="M12 9.5a2.5 2.5 0 1 0 0 5 2.5 2.5 0 0 0 0-5z"></path>
    </svg>',

    'send' => '<svg viewBox="0 0 24 24" aria-hidden="true">
      <path d="M22 2L11 13"></path>
      <path d="M22 2l-7 20-4-9-9-4 20-7z"></path>
    </svg>',
    default => '',
  };
};

$sal = $fmtMoney($it['moneda'] ?? 'CRC', $it['salario_min'] ?? null, $it['salario_max'] ?? null);

$empresaNombre = trim((string)($it['empresa_nombre'] ?? ''));
if ($empresaNombre === '') $empresaNombre = 'Empresa #' . (int)($it['empresa_user_id'] ?? 0);

$empresaLogoUrl = feed_asset_url($bp, (string)($it['empresa_logo_path'] ?? ''));
$empresaVerif   = (int)($it['empresa_verificada'] ?? 0) === 1;
$empresaRating  = (float)($it['empresa_rating'] ?? 0);
$isIdeal        = (int)($it['is_ideal'] ?? 0) === 1;

$pubDtRaw = (string)($it['fecha_feed'] ?? $it['publicada_en'] ?? $it['creado_en'] ?? '');
$pubLabel = '—';
if ($pubDtRaw !== '') {
  try { $pubLabel = (new DateTime($pubDtRaw))->format('d/m/Y H:i'); } catch (Throwable $e) {}
}

$vacImgUrl = feed_asset_url($bp, (string)($it['imagen_path'] ?? ''));

$postId = isset($it['postulacion_id']) ? (int)$it['postulacion_id'] : 0;
$postEstado = isset($it['postulacion_estado']) ? (string)$it['postulacion_estado'] : null;
[$bClass, $bLabel] = $badgeEstadoPost($postEstado);
$yaPostulo = $postId > 0;

$myReaction = (string)($it['my_reaction'] ?? '');
$cLike = (int)($it['reac_like'] ?? 0);
$cRec  = (int)($it['reac_recommend'] ?? 0);
$cExc  = (int)($it['reac_excellent'] ?? 0);
$cBad  = (int)($it['reac_bad'] ?? 0);
$cShr  = (int)($it['shares_count'] ?? 0);

$catsVac = trim((string)($it['categorias_vacante'] ?? ''));
$catsMat = trim((string)($it['categorias_match'] ?? ''));

// insignia: patrocinada > top > básica
$insignia = 'Empresa';
$insVariant = 'neutral';
$insIcon = 'badge';
if ($isIdeal) {
  $insignia = 'Patrocinada';
  $insVariant = 'warn';
  $insIcon = 'bolt';
} elseif ($empresaRating >= 4.5) {
  $insignia = 'Top';
  $insVariant = 'success';
  $insIcon = 'sparkle';
}

// estado derecho para postulante
$rightLabel = 'Disponible';
$rightVariant = 'neutral';
$rightIcon = 'badge';
if ($tipo !== 'empresa') {
  if ($isIdeal) { $rightLabel = 'Ideal para ti'; $rightVariant = 'warn'; $rightIcon='sparkle'; }
  elseif ($yaPostulo) {
    $rightLabel = $bLabel;
    $rightVariant = match ($bClass) {
      'success' => 'success',
      'danger'  => 'danger',
      'info'    => 'info',
      default   => 'neutral'
    };
    $rightIcon = 'check';
  }
}

// Etiquetas para reacciones (visibles)
$rx = [
  'like'      => ['label' => '',        'icon' => 'heart',  'count' => $cLike],
  'recommend' => ['label' => '',      'icon' => 'star',   'count' => $cRec],
  'excellent' => ['label' => '',       'icon' => 'check',  'count' => $cExc],
  'bad'       => ['label' => '',       'icon' => 'warn',   'count' => $cBad],
  'share'     => ['label' => '',       'icon' => 'share',  'count' => $cShr],
];

// ID único por card para scope CSS si necesitas (evita colisiones raras)
$cardId = 'vac_' . $vid;
?>

<style>
/* ===== Vac Card (encapsulado) ===== */
#<?= htmlspecialchars($cardId) ?>.vac-card{
  border:1px solid #e8eefc;
  border-radius:16px;
  background:#fff;
  box-shadow: 0 6px 22px rgba(15, 30, 80, .06);
}
#<?= htmlspecialchars($cardId) ?> .vac-logo{
  width:44px; height:44px;
  border-radius:14px;
  border:1px solid #e8eefc;
  background:#fff;
  object-fit:cover;
}
#<?= htmlspecialchars($cardId) ?> .vac-logo--ph{
  width:44px; height:44px;
  border-radius:14px;
  border:1px solid #e8eefc;
  background:linear-gradient(180deg, #f7f9ff, #eef3ff);
}
#<?= htmlspecialchars($cardId) ?> .vac-company{
  font-weight:700;
  color:#0b1220;
}
#<?= htmlspecialchars($cardId) ?> .vac-headline{
  line-height:1.15;
}
#<?= htmlspecialchars($cardId) ?> .vac-meta{
  display:flex;
  align-items:center;
  gap:8px;
  color:#5b6b86;
}
#<?= htmlspecialchars($cardId) ?> .vac-title{
  font-size:1.06rem;
  font-weight:750;
  color:#0b1220;
  letter-spacing:.1px;
}
#<?= htmlspecialchars($cardId) ?> .vac-sub{
  color:#5b6b86;
  display:flex;
  flex-wrap:wrap;
  gap:10px;
}
#<?= htmlspecialchars($cardId) ?> .vac-image{
  width:100%;
  aspect-ratio:1080/1180;
  object-fit:cover;
  border-radius:14px;
  border:1px solid #e8eefc;
  background:#fff;
}
#<?= htmlspecialchars($cardId) ?> .vac-kicker{
  color:#5b6b86;
}
#<?= htmlspecialchars($cardId) ?> .vac-salary{
  font-weight:800;
  color:#0b1220;
}
#<?= htmlspecialchars($cardId) ?> .vac-desc{
  color:#0b1220;
  opacity:.92;
  white-space:normal;
}

/* ===== Chips ===== */
#<?= htmlspecialchars($cardId) ?> .vac-chip{
  display:inline-flex;
  align-items:center;
  gap:6px;
  padding:6px 10px;
  border-radius:999px;
  border:1px solid #e8eefc;
  background:#f7f9ff;
  color:#0b1220;
  font-size:.82rem;
  font-weight:700;
  line-height:1;
}
#<?= htmlspecialchars($cardId) ?> .vac-chip--neutral{ background:#f7f9ff; }
#<?= htmlspecialchars($cardId) ?> .vac-chip--info{ background:#eef3ff; color:#1d4ed8; }
#<?= htmlspecialchars($cardId) ?> .vac-chip--success{ background:#ecfdf5; color:#065f46; border-color:#d1fae5; }
#<?= htmlspecialchars($cardId) ?> .vac-chip--danger{ background:#fff1f2; color:#9f1239; border-color:#ffe4e6; }
#<?= htmlspecialchars($cardId) ?> .vac-chip--warn{ background:#fffbeb; color:#92400e; border-color:#fde68a; }

/* ===== SVG base ===== */
#<?= htmlspecialchars($cardId) ?> .vac-ico svg{
  width:16px; height:16px;
  display:block;
  fill:none;
  stroke:currentColor;
  stroke-width:2;
  stroke-linecap:round;
  stroke-linejoin:round;
}
#<?= htmlspecialchars($cardId) ?> .vac-ico--muted{ color:#5b6b86; opacity:.9; }

/* ===== Reactions: SOLO este hace scroll horizontal, sin barra visible ===== */
#<?= htmlspecialchars($cardId) ?> .vac-actions{
  display:flex;
  align-items:center;
  gap:10px;
}
#<?= htmlspecialchars($cardId) ?> .vac-reactions{
  display:flex;
  align-items:center;
  gap:8px;
  overflow-x:auto;
  overflow-y:hidden;
  padding:4px 2px;
  max-width:100%;
  -webkit-overflow-scrolling:touch;
  scrollbar-width:none;            /* Firefox */
}
#<?= htmlspecialchars($cardId) ?> .vac-reactions::-webkit-scrollbar{ display:none; } /* Chrome/Safari */
#<?= htmlspecialchars($cardId) ?> .vac-reactions:focus{ outline:none; }

#<?= htmlspecialchars($cardId) ?> .vac-action{
  flex:0 0 auto;
  display:inline-flex;
  align-items:center;
  gap:8px;
  border-radius:999px;
  border:1px solid #e8eefc;
  background:#fff;
  padding:8px 10px;
  color:#0b1220;
  font-weight:800;
  font-size:.86rem;
  line-height:1;
  transition: background .15s ease, border-color .15s ease, transform .05s ease;
}
#<?= htmlspecialchars($cardId) ?> .vac-action:hover{
  background:#f7f9ff;
  border-color:#d7e2ff;
}
#<?= htmlspecialchars($cardId) ?> .vac-action:active{ transform: translateY(1px); }
#<?= htmlspecialchars($cardId) ?> .vac-action.is-on{
  background:#245bff;
  border-color:#245bff;
  color:#fff;
}
#<?= htmlspecialchars($cardId) ?> .vac-action .vac-count{
  display:inline-flex;
  min-width:22px;
  justify-content:center;
  padding:3px 8px;
  border-radius:999px;
  background:#f1f5ff;
  border:1px solid #e8eefc;
  color:#0b1220;
  font-size:.82rem;
  font-weight:900;
}
#<?= htmlspecialchars($cardId) ?> .vac-action.is-on .vac-count{
  background:rgba(255,255,255,.18);
  border-color:rgba(255,255,255,.25);
  color:#fff;
}

/* label visible para cada reacción */
#<?= htmlspecialchars($cardId) ?> .vac-action .vac-label{
  white-space:nowrap;
  color:inherit;
  font-weight:800;
}
@media (max-width: 420px){
  /* compacta sin perder etiqueta */
  #<?= htmlspecialchars($cardId) ?> .vac-action{ padding:8px 9px; gap:7px; }
  #<?= htmlspecialchars($cardId) ?> .vac-action .vac-label{ font-size:.84rem; }
}
</style>

<div id="<?= htmlspecialchars($cardId) ?>" class="app-card vac-card p-3 mb-3">

  <!-- Header -->
  <div class="d-flex justify-content-between align-items-start gap-2">
    <div class="d-flex gap-2 align-items-start">
      <?php if ($empresaLogoUrl !== ''): ?>
        <img src="<?= htmlspecialchars($empresaLogoUrl) ?>"
             alt="Logo empresa"
             class="vac-logo"
             loading="lazy">
      <?php else: ?>
        <div class="vac-logo vac-logo--ph" aria-hidden="true"></div>
      <?php endif; ?>

      <div>
        <div class="vac-headline d-flex flex-wrap align-items-center gap-2">
          <span class="vac-company"><?= htmlspecialchars($empresaNombre) ?></span>

          <span class="vac-chip vac-chip--<?= htmlspecialchars($insVariant) ?>">
            <span class="vac-ico"><?= $icon($insIcon) ?></span>
            <span><?= htmlspecialchars($insignia) ?></span>
          </span>

          <span class="vac-chip vac-chip--neutral" title="Puntuación de empresa">
            <span class="vac-ico"><?= $icon('star') ?></span>
            <span><?= htmlspecialchars(number_format($empresaRating, 1)) ?></span>
          </span>

          <?php if ($empresaVerif): ?>
            <span class="vac-chip vac-chip--info">
              <span class="vac-ico"><?= $icon('check') ?></span>
              <span>Verificada</span>
            </span>
          <?php else: ?>
            <span class="vac-chip vac-chip--neutral">
              <span class="vac-ico"><?= $icon('shield') ?></span>
              <span>Básica</span>
            </span>
          <?php endif; ?>
        </div>

        <div class="vac-meta small mt-1">
          <span class="vac-ico vac-ico--muted"><?= $icon('clock') ?></span>
          <span><?= htmlspecialchars($pubLabel) ?> • <?= htmlspecialchars(feed_time_ago($pubDtRaw)) ?></span>
        </div>
      </div>
    </div>

    <?php if ($tipo === 'empresa'): ?>
      <span class="vac-chip vac-chip--neutral">
        <span class="vac-ico"><?= $icon('badge') ?></span>
        <span><?= htmlspecialchars((string)($it['estado'] ?? '—')) ?></span>
      </span>
    <?php else: ?>
      <span class="vac-chip vac-chip--<?= htmlspecialchars($rightVariant) ?>">
        <span class="vac-ico"><?= $icon($rightIcon) ?></span>
        <span><?= htmlspecialchars($rightLabel) ?></span>
      </span>
    <?php endif; ?>
  </div>

  <!-- Title + meta -->
  <div class="mt-3">
    <div class="vac-title">
      <?= htmlspecialchars((string)($it['titulo'] ?? '')) ?>
    </div>

    <div class="vac-sub small mt-1">
      <span>
        <span class="vac-ico vac-ico--muted"><?= $icon('pin') ?></span>
        <?= htmlspecialchars((string)($it['ubicacion'] ?? '—')) ?>
      </span>
      <span>
        <span class="vac-ico vac-ico--muted"><?= $icon('layers') ?></span>
        <?= htmlspecialchars((string)($it['modalidad'] ?? '—')) ?>
      </span>
      <span>
        <span class="vac-ico vac-ico--muted"><?= $icon('briefcase') ?></span>
        <?= htmlspecialchars((string)($it['tipo_empleo'] ?? '—')) ?>
      </span>
    </div>

    <?php if ($tipo !== 'empresa' && $catsVac !== ''): ?>
      <div class="vac-cats small mt-2">
        <span class="me-1">Categorías:</span>
        <span><?= htmlspecialchars($catsVac) ?></span>
        <?php if ($catsMat !== ''): ?>
          <span class="vac-chip vac-chip--success ms-2">
            <span class="vac-ico"><?= $icon('check') ?></span>
            <span>Match: <?= htmlspecialchars($catsMat) ?></span>
          </span>
        <?php endif; ?>
      </div>
    <?php endif; ?>
  </div>

  <!-- Imagen -->
  <?php if ($vacImgUrl !== ''): ?>
    <div class="mt-3">
      <img src="<?= htmlspecialchars($vacImgUrl) ?>"
           alt="Imagen vacante"
           class="vac-image"
           loading="lazy">
    </div>
  <?php endif; ?>

  <!-- Salario + descripción -->
  <div class="mt-3">
    <div class="vac-kicker small">Salario</div>
    <div class="vac-salary"><?= htmlspecialchars($sal) ?></div>

    <?php
      $descRaw = (string)($it['descripcion'] ?? '');
      $descHtml = feed_safe_html_excerpt($descRaw, 420);
    ?>
    <?php if ($descHtml !== ''): ?>
      <div class="vac-desc small mt-2">
        <?= $descHtml ?>
      </div>
    <?php endif; ?>
  </div>

  <!-- SOCIAL BAR -->
  <div class="vac-actions mt-3 align-items-center"
       data-social-bar="1"
       data-vacante-id="<?= $vid ?>"
       data-kind="vacante"
       data-id="<?= $vid ?>"

    <!-- Solo este bloque scrollea horizontal sin barra -->
    <div class="vac-reactions" role="group" aria-label="Reacciones y acciones">
      <!-- Like -->
      <button type="button"
              class="vac-action <?= $myReaction==='like' ? 'is-on' : '' ?>"
              data-action="react" data-reaction="like"
              aria-label="Me gusta" title="Me gusta">
        <span class="vac-ico"><?= $icon($rx['like']['icon']) ?></span>
        <span class="vac-label"><?= htmlspecialchars($rx['like']['label']) ?></span>
        <span class="vac-count" data-count="like"><?= (int)$rx['like']['count'] ?></span>
      </button>

      <!-- Recommend -->
      <button type="button"
              class="vac-action <?= $myReaction==='recommend' ? 'is-on' : '' ?>"
              data-action="react" data-reaction="recommend"
              aria-label="Recomendar" title="Recomendar">
        <span class="vac-ico"><?= $icon($rx['recommend']['icon']) ?></span>
        <span class="vac-label"><?= htmlspecialchars($rx['recommend']['label']) ?></span>
        <span class="vac-count" data-count="recommend"><?= (int)$rx['recommend']['count'] ?></span>
      </button>

      <!-- Excellent -->
      <button type="button"
              class="vac-action <?= $myReaction==='excellent' ? 'is-on' : '' ?>"
              data-action="react" data-reaction="excellent"
              aria-label="Excelente" title="Excelente">
        <span class="vac-ico"><?= $icon($rx['excellent']['icon']) ?></span>
        <span class="vac-label"><?= htmlspecialchars($rx['excellent']['label']) ?></span>
        <span class="vac-count" data-count="excellent"><?= (int)$rx['excellent']['count'] ?></span>
      </button>

      <!-- Bad -->
      <button type="button"
              class="vac-action <?= $myReaction==='bad' ? 'is-on' : '' ?>"
              data-action="react" data-reaction="bad"
              aria-label="Mala experiencia" title="Mala experiencia (privada)">
        <span class="vac-ico"><?= $icon($rx['bad']['icon']) ?></span>
        <span class="vac-label"><?= htmlspecialchars($rx['bad']['label']) ?></span>
        <span class="vac-count" data-count="bad"><?= (int)$rx['bad']['count'] ?></span>
      </button>
    </div>

    <span class="flex-grow-1"></span>

    <?php if ($tipo === 'empresa'): ?>
      <a class="btn btn-outline-primary btn-sm" href="<?= htmlspecialchars($bp . '/empresa/vacantes/edit?id=' . $vid) ?>">Editar</a>
      <a class="btn btn-outline-dark btn-sm" href="<?= htmlspecialchars($bp . '/empresa/postulaciones?vacante_id=' . $vid) ?>">
        Postulaciones (<?= (int)($it['postulaciones_count'] ?? 0) ?>)
      </a>
<?php else: ?>
  <a class="vac-ibtn"
     href="<?= htmlspecialchars($bp . '/vacantes/ver?id=' . $vid) ?>"
     data-tip="Ver detalle"
     aria-label="Ver detalle">
    <span class="vac-ico"><?= $icon('eye') ?></span>
  </a>

  <?php if (!$yaPostulo): ?>
    <form method="post" action="<?= htmlspecialchars($bp . '/vacantes/postular') ?>" class="d-inline">
      <input type="hidden" name="_csrf" value="<?= htmlspecialchars($csrf) ?>">
      <input type="hidden" name="vacante_id" value="<?= $vid ?>">
      <button class="vac-ibtn vac-ibtn--primary"
              type="submit"
              data-tip="Postular"
              aria-label="Postular">
        <span class="vac-ico"><?= $icon('send') ?></span>
      </button>
    </form>
  <?php else: ?>
    <button class="vac-ibtn is-disabled"
            type="button"
            disabled
            data-tip="Ya postulaste"
            aria-label="Ya postulaste">
      <span class="vac-ico"><?= $icon('check') ?></span>
    </button>
  <?php endif; ?>
<?php endif; ?>

  </div>
</div>
