<?php
/** @var array $items */
/** @var string $csrf */
$bp = base_path();
?>

<div class="container py-4">
  <div class="d-flex align-items-center justify-content-between mb-3">
    <div>
      <h3 class="mb-0">Notificaciones</h3>
      <div class="text-muted small">Últimas alertas del sistema.</div>
    </div>

    <form method="post" action="<?= htmlspecialchars($bp . '/postulante/notificaciones/read_all') ?>">
      <input type="hidden" name="_csrf" value="<?= htmlspecialchars($csrf) ?>">
      <button class="btn btn-outline-secondary btn-sm">Marcar todo como leído</button>
    </form>
  </div>

  <div class="card">
    <div class="card-body p-0">
      <?php if (empty($items)): ?>
        <div class="p-4 text-center text-muted">No hay notificaciones.</div>
      <?php else: ?>
        <div class="list-group list-group-flush">
          <?php foreach ($items as $n): ?>
            <?php
              $isRead = (int)($n['is_read'] ?? 0) === 1;
              $url = (string)($n['url'] ?? '');
            ?>
            <div class="list-group-item">
              <div class="d-flex justify-content-between gap-3">
                <div>
                  <div class="fw-semibold">
                    <?= htmlspecialchars((string)($n['title'] ?? '')) ?>
                    <?php if (!$isRead): ?>
                      <span class="badge text-bg-primary ms-2">Nuevo</span>
                    <?php endif; ?>
                  </div>
                  <?php if (!empty($n['body'])): ?>
                    <div class="small text-muted"><?= nl2br(htmlspecialchars((string)$n['body'])) ?></div>
                  <?php endif; ?>
                  <div class="small text-muted mt-1"><?= htmlspecialchars((string)($n['creado_en'] ?? '')) ?></div>
                </div>

                <div class="d-flex align-items-center gap-2">
                  <?php if ($url !== ''): ?>
                    <a class="btn btn-sm btn-outline-primary" href="<?= htmlspecialchars($url) ?>">Abrir</a>
                  <?php endif; ?>

                  <?php if (!$isRead): ?>
                    <form method="post" action="<?= htmlspecialchars($bp . '/postulante/notificaciones/read') ?>">
                      <input type="hidden" name="_csrf" value="<?= htmlspecialchars($csrf) ?>">
                      <input type="hidden" name="id" value="<?= (int)($n['id'] ?? 0) ?>">
                      <button class="btn btn-sm btn-outline-secondary">Marcar leído</button>
                    </form>
                  <?php endif; ?>
                </div>
              </div>
            </div>
          <?php endforeach; ?>
        </div>
      <?php endif; ?>
    </div>
  </div>
</div>
