<?php
/** @var array $user */
/** @var array $perfil */
/** @var ?array $cv */
/** @var array $selectedCats */
/** @var array $stats */

$bp = base_path();

$user = is_array($user ?? null) ? $user : [];
$perfil = is_array($perfil ?? null) ? $perfil : [];
$selectedCats = is_array($selectedCats ?? null) ? $selectedCats : [];
$stats = is_array($stats ?? null) ? $stats : [];
$cv = is_array($cv ?? null) ? $cv : null;

$nombre = trim((string)($user['nombre'] ?? ''));
if ($nombre === '') $nombre = 'Postulante';

$titulo = trim((string)($perfil['titulo_profesional'] ?? ''));
$ubic   = trim((string)($perfil['ubicacion'] ?? ''));
$portfolio = trim((string)($perfil['portfolio_url'] ?? ''));

$bioHtml = trim((string)($perfil['bio'] ?? ''));
$retosRaw = trim((string)($perfil['retos'] ?? ''));

function is_http_url(string $url): bool { return (bool)preg_match('~^https?://~i', $url); }
function fmt_int(int $n): string { return number_format($n, 0, '.', ','); }

/**
 * Sanitizado básico para bio HTML:
 * - elimina scripts/iframes/style
 * - permite tags comunes
 * - elimina on* y style
 */
function safe_public_html(string $html): string {
  $html = trim($html);
  if ($html === '') return '';
  $html = preg_replace('~<(script|iframe|object|embed|style)\b[^>]*>.*?</\1>~is', '', $html) ?? '';
  $allowed = '<p><br><b><strong><i><em><u><h1><h2><h3><h4><ul><ol><li><a><blockquote><code><pre><hr>';
  $html = strip_tags($html, $allowed);
  $html = preg_replace('~\son\w+\s*=\s*(".*?"|\'.*?\'|[^\s>]+)~i', '', $html) ?? '';
  $html = preg_replace('~\sstyle\s*=\s*(".*?"|\'.*?\')~i', '', $html) ?? '';
  $html = preg_replace_callback('~<a\s+([^>]*?)href\s*=\s*("|\')(.*?)\2([^>]*)>~i', function($m){
    $before = $m[1] ?? '';
    $q = $m[2] ?? '"';
    $href = trim((string)($m[3] ?? ''));
    $after = $m[4] ?? '';
    if ($href === '' || preg_match('~^(javascript:|data:)~i', $href)) $href = '#';
    if ($href !== '#' && !preg_match('~^https?://~i', $href)) $href = '#';
    return '<a ' . $before . 'href=' . $q . htmlspecialchars($href, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8') . $q . $after . ' target="_blank" rel="noopener noreferrer">';
  }, $html);
  return $html;
}

$totalPost = (int)($stats['total'] ?? 0);
$enviada   = (int)($stats['enviada'] ?? 0);
$vista     = (int)($stats['vista'] ?? 0);
$pre       = (int)($stats['preseleccion'] ?? 0);
$rech      = (int)($stats['rechazada'] ?? 0);

$chips = [];
if ($ubic !== '') $chips[] = ['muted', $ubic];
if (!empty($selectedCats)) $chips[] = ['primary', count($selectedCats) . ' rol(es)'];
$chips[] = [$cv && (int)($cv['id'] ?? 0) > 0 ? 'success' : 'light', $cv && (int)($cv['id'] ?? 0) > 0 ? 'CV disponible' : 'CV no cargado'];

$retos = [];
if ($retosRaw !== '') {
  foreach (preg_split('~\R~u', $retosRaw) as $ln) {
    $ln = trim($ln);
    if ($ln !== '') $retos[] = $ln;
  }
}

$bioSafe = safe_public_html($bioHtml);
?>
<div class="container py-4">

  <div class="app-card p-4">
    <div class="d-flex flex-wrap align-items-start justify-content-between gap-3">
      <div style="min-width:260px;">
        <div class="text-muted small">Perfil público</div>
        <h2 class="mb-1"><?= e($nombre) ?></h2>
        <?php if ($titulo !== ''): ?>
          <div class="fw-semibold"><?= e($titulo) ?></div>
        <?php else: ?>
          <div class="text-muted">Título profesional pendiente</div>
        <?php endif; ?>

        <div class="d-flex flex-wrap gap-2 mt-3">
          <?php foreach ($chips as [$v,$t]): ?>
            <?php
              $cls = 'text-bg-light';
              if ($v === 'primary') $cls = 'text-bg-primary';
              if ($v === 'success') $cls = 'text-bg-success';
              if ($v === 'muted') $cls = 'text-bg-light';
            ?>
            <span class="badge <?= $cls ?>" style="<?= ($v==='muted'||$v==='light') ? 'border:1px solid #e8eefc;color:#0b1220;background:#fff;' : '' ?>">
              <?= e($t) ?>
            </span>
          <?php endforeach; ?>
        </div>

        <div class="d-flex gap-2 mt-3">
          <?php if ($portfolio !== '' && is_http_url($portfolio)): ?>
            <a class="btn btn-outline-primary btn-sm" href="<?= e($portfolio) ?>" target="_blank" rel="noopener noreferrer">Portafolio</a>
          <?php endif; ?>
          <a class="btn btn-outline-secondary btn-sm" href="<?= e($bp) ?>/registro?tipo=empresa">Soy empresa</a>
        </div>
      </div>

      <div class="p-3 rounded-3 border" style="border-color:#e8eefc;background:#fff;min-width:280px;">
        <div class="fw-semibold mb-2">Indicadores</div>
        <div class="d-grid gap-2">
          <div class="d-flex justify-content-between"><span class="text-muted small">Postulaciones</span><span class="fw-semibold"><?= e(fmt_int($totalPost)) ?></span></div>
          <div class="d-flex justify-content-between"><span class="text-muted small">Vistas</span><span class="fw-semibold"><?= e(fmt_int($vista)) ?></span></div>
          <div class="d-flex justify-content-between"><span class="text-muted small">Preselecciones</span><span class="fw-semibold"><?= e(fmt_int($pre)) ?></span></div>
          <div class="d-flex justify-content-between"><span class="text-muted small">Enviadas</span><span class="fw-semibold"><?= e(fmt_int($enviada)) ?></span></div>
          <div class="d-flex justify-content-between"><span class="text-muted small">Rechazadas</span><span class="fw-semibold"><?= e(fmt_int($rech)) ?></span></div>
        </div>
        <div class="small text-muted mt-2">Métricas reales del sistema (no inventadas).</div>
      </div>
    </div>

    <hr class="my-4">

    <div class="row g-3">
      <div class="col-12 col-lg-8">

        <div class="p-3 rounded-3 border" style="border-color:#e8eefc;background:#fff;">
          <div class="fw-semibold mb-2">Resumen</div>
          <?php if ($bioSafe !== ''): ?>
            <div class="small" style="line-height:1.5;">
              <?= $bioSafe ?>
            </div>
          <?php else: ?>
            <div class="text-muted small">Este perfil aún no tiene bio pública.</div>
          <?php endif; ?>
        </div>

        <div class="p-3 rounded-3 border mt-3" style="border-color:#e8eefc;background:#fff;">
          <div class="fw-semibold mb-2">Roles / categorías</div>
          <?php if (empty($selectedCats)): ?>
            <div class="text-muted small">Sin roles aún. Esto reduce el match con vacantes.</div>
          <?php else: ?>
            <div class="d-flex flex-wrap gap-2">
              <?php foreach ($selectedCats as $c): ?>
                <span class="badge text-bg-secondary"><?= e((string)($c['nombre'] ?? '')) ?></span>
              <?php endforeach; ?>
            </div>
          <?php endif; ?>
          <div class="small text-muted mt-2">Estas categorías alimentan recomendaciones y segmentación.</div>
        </div>

        <div class="p-3 rounded-3 border mt-3" style="border-color:#e8eefc;background:#fff;">
          <div class="fw-semibold mb-2">Retos asumidos</div>
          <?php if (empty($retos)): ?>
            <div class="text-muted small">El postulante aún no ha definido retos asumidos.</div>
          <?php else: ?>
            <ul class="small mb-0">
              <?php foreach ($retos as $r): ?>
                <li><?= e($r) ?></li>
              <?php endforeach; ?>
            </ul>
          <?php endif; ?>
        </div>

      </div>

      <div class="col-12 col-lg-4">
        <div class="p-3 rounded-3 border" style="border-color:#e8eefc;background:#fff;">
          <div class="fw-semibold mb-2">Acción</div>
          <div class="small text-muted">Si sos empresa, publicá una vacante y el sistema hará match por roles.</div>
          <div class="d-grid mt-3">
            <a class="btn btn-primary btn-sm" href="<?= e($bp) ?>/registro?tipo=empresa">Crear cuenta empresa</a>
          </div>
        </div>

        <div class="p-3 rounded-3 border mt-3" style="border-color:#e8eefc;background:#fff;">
          <div class="fw-semibold mb-2">Contacto</div>
          <div class="small text-muted">El contacto directo lo controla el sistema vía postulaciones (más seguro).</div>
        </div>
      </div>
    </div>

  </div>
</div>
