<?php declare(strict_types=1);
/** @var string $csrf */
/** @var array $row */
/** @var string|null $error */
/** @var string|null $ok */

$bp = base_path();
$r = $row ?? [];
$id = (int)($r['id'] ?? 0);
?>
<div class="card border-0 shadow-sm rounded-4">
  <div class="card-body p-4">
    <div class="h5 mb-2"><?= $id>0 ? 'Editar anuncio' : 'Nuevo anuncio' ?></div>

    <?php if ($error): ?><div class="alert alert-danger"><?= e($error) ?></div><?php endif; ?>
    <?php if ($ok): ?><div class="alert alert-success"><?= e($ok) ?></div><?php endif; ?>

    <form method="post" action="<?= e($bp) ?>/rrhh/anuncios/editar" class="row g-3">
      <input type="hidden" name="_csrf" value="<?= e($csrf) ?>">
      <input type="hidden" name="id" value="<?= $id ?>">

      <div class="col-12">
        <label class="form-label">Título</label>
        <input class="form-control" name="titulo" value="<?= e((string)($r['titulo'] ?? '')) ?>" required>
      </div>

      <div class="col-12 col-lg-4">
        <label class="form-label">Tipo</label>
        <select class="form-select" name="tipo">
          <?php
            $tipo = (string)($r['tipo'] ?? 'servicio');
            $opts = ['servicio'=>'Servicio','oferta'=>'Oferta','comunicado'=>'Comunicado','otro'=>'Otro'];
            foreach ($opts as $k=>$v) {
              $sel = $tipo===$k ? 'selected' : '';
              echo '<option value="'.e($k).'" '.$sel.'>'.e($v).'</option>';
            }
          ?>
        </select>
      </div>

      <div class="col-12 col-lg-4">
        <label class="form-label">Estado</label>
        <select class="form-select" name="estado">
          <?php
            $est = (string)($r['estado'] ?? 'borrador');
            foreach (['borrador'=>'Borrador','publicado'=>'Publicado','archivado'=>'Archivado'] as $k=>$v) {
              $sel = $est===$k ? 'selected' : '';
              echo '<option value="'.e($k).'" '.$sel.'>'.e($v).'</option>';
            }
          ?>
        </select>
      </div>

      <div class="col-12 col-lg-4">
        <label class="form-label">Slug</label>
        <input class="form-control" name="slug" value="<?= e((string)($r['slug'] ?? '')) ?>" placeholder="Opcional">
      </div>

      <div class="col-12">
        <label class="form-label">Descripción</label>
        <textarea class="form-control" name="descripcion" rows="6" required><?= e((string)($r['descripcion'] ?? '')) ?></textarea>
      </div>

      <div class="col-12 d-flex gap-2">
        <button class="btn btn-primary">Guardar</button>
        <a class="btn btn-outline-secondary" href="<?= e($bp) ?>/rrhh/anuncios">Volver</a>

        <?php if ($id>0): ?>
          <button class="btn btn-outline-danger ms-auto" name="action" value="delete" onclick="return confirm('¿Eliminar anuncio?')">Eliminar</button>
        <?php endif; ?>
      </div>
    </form>

  </div>
</div>
