<?php declare(strict_types=1);
/** @var string $csrf */
/** @var array $items */
/** @var array $cats */
$bp = base_path();
?>
<div class="card border-0 shadow-sm rounded-4">
  <div class="card-body p-4">
    <div class="h5 mb-1">Boost (RRHH)</div>
    <div class="text-muted small mb-3">Módulo monetizable: aumenta el alcance de tus publicaciones (anuncios / perfil).</div>

    <form method="post" action="<?= e($bp) ?>/rrhh/boosts/create" class="row g-3">
      <input type="hidden" name="_csrf" value="<?= e($csrf) ?>">

      <div class="col-12 col-lg-3">
        <label class="form-label">Scope</label>
        <select class="form-select" name="scope">
          <option value="para_ti">Para ti (targeted)</option>
          <option value="global">Global</option>
        </select>
      </div>

      <div class="col-12 col-lg-4">
        <label class="form-label">Categoría (opcional)</label>
        <select class="form-select" name="categoria_id">
          <option value="0">Todas</option>
          <?php foreach (($cats ?? []) as $c): ?>
            <option value="<?= (int)$c['id'] ?>"><?= e((string)$c['nombre']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>

      <div class="col-12 col-lg-2">
        <label class="form-label">Score boost</label>
        <input class="form-control" type="number" name="score_boost" value="600" min="0" max="5000">
      </div>

      <div class="col-12 col-lg-2">
        <label class="form-label">Días</label>
        <input class="form-control" type="number" name="days" value="7" min="1" max="30">
      </div>

      <div class="col-12 col-lg-1 d-flex align-items-end">
        <button class="btn btn-primary w-100">+</button>
      </div>
    </form>

    <hr>

    <div class="table-responsive">
      <table class="table align-middle">
        <thead>
          <tr>
            <th>Estado</th>
            <th>Scope</th>
            <th>Categoría</th>
            <th>Score</th>
            <th>Vence</th>
            <th style="width:120px;">Acción</th>
          </tr>
        </thead>
        <tbody>
        <?php foreach (($items ?? []) as $it): ?>
          <tr>
            <td><?= e((string)$it['estado']) ?></td>
            <td><?= e((string)$it['scope']) ?></td>
            <td><?= e((string)($it['categoria_nombre'] ?? 'Todas')) ?></td>
            <td><?= (int)$it['score_boost'] ?></td>
            <td class="text-muted small"><?= e((string)$it['ends_at']) ?></td>
            <td>
              <?php if (($it['estado'] ?? '') === 'activo'): ?>
                <form method="post" action="<?= e($bp) ?>/rrhh/boosts/disable">
                  <input type="hidden" name="_csrf" value="<?= e($csrf) ?>">
                  <input type="hidden" name="id" value="<?= (int)$it['id'] ?>">
                  <button class="btn btn-outline-danger btn-sm">Desactivar</button>
                </form>
              <?php else: ?>
                <span class="text-muted small">—</span>
              <?php endif; ?>
            </td>
          </tr>
        <?php endforeach; ?>
        </tbody>
      </table>
    </div>

  </div>
</div>
