<?php declare(strict_types=1);
/** @var array $items */
?>
<div class="card border-0 shadow-sm rounded-4">
  <div class="card-body p-4">
    <div class="h5 mb-2">Notificaciones</div>
    <div class="text-muted small mb-3">Alertas del sistema.</div>

    <?php if (empty($items)): ?>
      <div class="text-muted">No hay notificaciones.</div>
    <?php else: ?>
      <div class="list-group">
        <?php foreach ($items as $n): ?>
          <div class="list-group-item">
            <div class="fw-semibold"><?= e((string)($n['titulo'] ?? 'Notificación')) ?></div>
            <div class="text-muted small"><?= e((string)($n['creado_en'] ?? '')) ?></div>
            <div><?= e((string)($n['mensaje'] ?? '')) ?></div>
          </div>
        <?php endforeach; ?>
      </div>
    <?php endif; ?>
  </div>
</div>
