<?php declare(strict_types=1);
/** @var string $csrf */
/** @var array $profile */
/** @var string|null $error */
/** @var string|null $ok */

$bp = base_path();
$p = $profile ?? [];

$empresaId = (int)($p['empresa_user_id'] ?? 0);
?>
<div class="card border-0 shadow-sm rounded-4">
  <div class="card-body p-4">
    <div class="h5 mb-2">Mi perfil RRHH</div>
    <div class="text-muted small mb-3">Este perfil es público. Aquí también puedes ligar tu cuenta a una empresa (opcional).</div>

    <?php if ($error): ?>
      <div class="alert alert-danger"><?= e($error) ?></div>
    <?php endif; ?>
    <?php if ($ok): ?>
      <div class="alert alert-success"><?= e($ok) ?></div>
    <?php endif; ?>

    <form method="post" action="<?= e($bp) ?>/rrhh/perfil" class="row g-3">
      <input type="hidden" name="_csrf" value="<?= e($csrf) ?>">

      <div class="col-12 col-lg-6">
        <label class="form-label">Nombre público</label>
        <input class="form-control" name="display_name" value="<?= e((string)($p['display_name'] ?? '')) ?>" placeholder="Ej: Ana Pérez">
      </div>

      <div class="col-12 col-lg-6">
        <label class="form-label">Slug (URL amigable)</label>
        <input class="form-control" name="slug" value="<?= e((string)($p['slug'] ?? '')) ?>" placeholder="ej: ana-perez-rrhh">
      </div>

      <div class="col-12">
        <label class="form-label">Titular</label>
        <input class="form-control" name="titular" value="<?= e((string)($p['titular'] ?? '')) ?>" placeholder="Ej: Especialista RRHH • Reclutamiento • Legislación laboral">
      </div>

      <div class="col-12">
        <label class="form-label">Bio</label>
        <textarea class="form-control" name="bio" rows="4" placeholder="Describe tu experiencia y enfoque."><?= e((string)($p['bio'] ?? '')) ?></textarea>
      </div>

      <div class="col-12 col-lg-4">
        <label class="form-label">Ubicación</label>
        <input class="form-control" name="ubicacion" value="<?= e((string)($p['ubicacion'] ?? '')) ?>">
      </div>
      <div class="col-12 col-lg-4">
        <label class="form-label">Teléfono</label>
        <input class="form-control" name="telefono" value="<?= e((string)($p['telefono'] ?? '')) ?>">
      </div>
      <div class="col-12 col-lg-4">
        <label class="form-label">Website</label>
        <input class="form-control" name="website" value="<?= e((string)($p['website'] ?? '')) ?>">
      </div>

      <div class="col-12 col-lg-6">
        <label class="form-label">LinkedIn</label>
        <input class="form-control" name="linkedin" value="<?= e((string)($p['linkedin'] ?? '')) ?>">
      </div>

      <div class="col-12 col-lg-6">
        <label class="form-label">Vincular a empresa (user_id)</label>
        <input class="form-control" name="empresa_user_id" value="<?= $empresaId > 0 ? (int)$empresaId : '' ?>" placeholder="Opcional. ID de empresa en users">
        <div class="form-text">Esto habilita el módulo de Vacantes desde RRHH, pero el ownership sigue siendo de la empresa.</div>
      </div>

      <div class="col-12 d-flex gap-2">
        <button class="btn btn-primary">Guardar</button>
        <a class="btn btn-outline-secondary" href="<?= e($bp) ?>/rrhh/ver?id=<?= (int)($p['user_id'] ?? 0) ?>">Ver perfil público</a>
      </div>
    </form>
  </div>
</div>
