<?php declare(strict_types=1);
/** @var string $csrf */
/** @var array $items */
/** @var string|null $error */
/** @var string|null $ok */

$bp = base_path();
?>
<div class="card border-0 shadow-sm rounded-4">
  <div class="card-body p-4">
    <div class="d-flex flex-wrap justify-content-between align-items-center gap-2">
      <div>
        <div class="h5 mb-1">Skills (porcentajes)</div>
        <div class="text-muted small">Categorías y porcentajes personalizados (ej.: “RRHH 90%”, “Abogada laboral 60%”).</div>
      </div>
    </div>

    <?php if ($error): ?><div class="alert alert-danger mt-3"><?= e($error) ?></div><?php endif; ?>
    <?php if ($ok): ?><div class="alert alert-success mt-3"><?= e($ok) ?></div><?php endif; ?>

    <hr>

    <form method="post" action="<?= e($bp) ?>/rrhh/skills" class="row g-3">
      <input type="hidden" name="_csrf" value="<?= e($csrf) ?>">
      <input type="hidden" name="action" value="create">

      <div class="col-12 col-lg-3">
        <label class="form-label">Categoría</label>
        <input class="form-control" name="categoria" placeholder="Ej: Legal / RRHH / TI / Soft Skills">
      </div>
      <div class="col-12 col-lg-4">
        <label class="form-label">Label</label>
        <input class="form-control" name="label" placeholder="Ej: Abogada laboral">
      </div>
      <div class="col-12 col-lg-2">
        <label class="form-label">%</label>
        <input class="form-control" name="porcentaje" type="number" min="0" max="100" value="60">
      </div>
      <div class="col-12 col-lg-2">
        <label class="form-label">Orden</label>
        <input class="form-control" name="orden" type="number" value="0">
      </div>
      <div class="col-12 col-lg-1 d-flex align-items-end">
        <button class="btn btn-primary w-100">+</button>
      </div>
    </form>

    <hr>

    <div class="table-responsive">
      <table class="table align-middle">
        <thead>
          <tr>
            <th>Categoría</th>
            <th>Skill</th>
            <th>%</th>
            <th>Orden</th>
            <th>Estado</th>
            <th style="width:220px;">Acciones</th>
          </tr>
        </thead>
        <tbody>
        <?php foreach (($items ?? []) as $it): ?>
          <tr>
            <td><?= e((string)$it['categoria']) ?></td>
            <td><?= e((string)$it['label']) ?></td>
            <td><span class="badge bg-primary"><?= (int)$it['porcentaje'] ?>%</span></td>
            <td><?= (int)$it['orden'] ?></td>
            <td><?= e((string)$it['estado']) ?></td>
            <td>
              <form method="post" action="<?= e($bp) ?>/rrhh/skills" class="d-flex gap-2">
                <input type="hidden" name="_csrf" value="<?= e($csrf) ?>">
                <input type="hidden" name="id" value="<?= (int)$it['id'] ?>">

                <input type="hidden" name="action" value="update">
                <input type="hidden" name="categoria" value="<?= e((string)$it['categoria']) ?>">
                <input type="hidden" name="label" value="<?= e((string)$it['label']) ?>">
                <input type="hidden" name="porcentaje" value="<?= (int)$it['porcentaje'] ?>">
                <input type="hidden" name="orden" value="<?= (int)$it['orden'] ?>">
                <input type="hidden" name="estado" value="<?= e((string)($it['estado'] === 'activo' ? 'inactivo' : 'activo')) ?>">

                <button class="btn btn-outline-secondary btn-sm" type="submit">
                  <?= $it['estado']==='activo' ? 'Desactivar' : 'Activar' ?>
                </button>

                <input type="hidden" name="action" value="delete">
                <button class="btn btn-outline-danger btn-sm" type="submit" onclick="return confirm('¿Eliminar skill?')">Eliminar</button>
              </form>
            </td>
          </tr>
        <?php endforeach; ?>
        </tbody>
      </table>
    </div>

  </div>
</div>
